<?php
// Kitap Sınıfı
class Kitap {
  public $ad;
  public $sayfa;
  public $fiyat;
  public $kdv;
  public $tur;
  public function __construct($ad, $sayfa, $fiyat, $kdv=0.08){
    $this->tur = 'Kitap';
    $this->ad = $ad;
    $this->sayfa = $sayfa;
    $this->fiyat = $fiyat;
    $this->kdv = $kdv;
  }
  function KdvliFiyat(){
    return $this->fiyat * (1+$this->kdv);
  }
  public function __toString(){
    return sprintf('Yayın Türü: <b>%s</b><br>', $this->tur).
      sprintf('Adı: <b>%s</b><br>',$this->ad).
      sprintf('Sayfa Sayısı: <b>%d</b><br>', $this->sayfa).
      sprintf('Fiyat: <b>%.2f TL</b><br>', $this->fiyat).
      sprintf('KDV\'li Fiyat: <b>%.2f TL</b><br>', $this->KdvliFiyat());
  }
}
// Kitap'tan devralan Dergi sınıfı
class Dergi extends Kitap{
  public $yil;
  public $sayi;
  public function __construct($ad, $sayfa, $fiyat, $yil, $sayi, $kdv=0.08){
    parent::__construct($ad, $sayfa, $fiyat, $kdv);
    $this->tur = 'Dergi';
    $this->yil = $yil;
    $this->sayi = $sayi;
  }
  public function __toString(){
    return parent::__toString().
      sprintf('Yıl: <b>%d</b><br>', $this->yil).
      sprintf('Sayı: <b>%d</b><br>', $this->sayi);
  }
}
// Kitaptan devralan Ansiklopedi sınıfı
class Ansiklopedi extends Kitap{
  public $cilt;
  public function __construct($ad, $fiyat, $cilt, $kdv=0.08){
    parent::__construct($ad, 0, $fiyat, $kdv);
    $this->tur = 'Ansiklopedi';
    $this->cilt = $cilt;
  }
  public function __toString(){
    return sprintf('Yayın Türü: <b>%s</b><br>', $this->tur).
      sprintf('Adı: <b>%s</b><br>',$this->ad).
      sprintf('Fiyat: <b>%.2f TL</b><br>', $this->fiyat).
      sprintf('KDV\'li Fiyat: <b>%.2f TL</b><br>', $this->KdvliFiyat()).
      sprintf('Cilt: <b>%d</b><br>', $this->cilt);
  }
}
// Ana Program Kodu
$k = new Kitap('PHP ile İnternet Programcılığı', 300, 20);
$d = new Dergi('Programlama Dünyası', 35, 15, 2016, 122);
$a = new Ansiklopedi('Büyük Osmanlı Tarihi', 223, 10);
echo '<p>'.$k.'</p>';
echo '<p>'.$d.'</p>';
echo '<p>'.$a.'</p>';